package w83b.w83bBeans;

import java.io.InputStream;
import java.sql.Blob;
import java.sql.ResultSet;

import w83b.util.jdbc.W83bDataBase;
import w83b.w83bDAO.w83bConstantesBD.W83bImpugnacionesBD;
import w83b.w83bDAO.w83bConstantesBD.W83bPreavisosBD;
import w83b.w83bDAO.w83bConstantesBD.W83bTramitesBD;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bDocBeanImpug.
 */
public class W83bDocBeanImpug extends W83bBaseBean implements W83bBaseBeanBD{

	/** The id. */
	public String id="";
	
	/** The nombre. */
	private String nombre="";
	
	/** The tipo documento. */
	private String tipoDocumento="";
	
	/** The fecha registro. */
	private String fechaRegistro="";
	
	/** The numero registro. */
	private String numeroRegistro="";
	
	/** The usuario. */
	private String usuario="";
	
	/** The file data. */
	private InputStream fileData;
	
	/** The file data blob. */
	private Blob fileDataBlob;
	
	/** The cod fase. */
	private String codFase;
	
	/** The cod tramite. */
	private String codTramite;
	
	/** The desc tramite. */
	private String descTramite;
	
	/** The dese tramite. */
	private String deseTramite;
	
	/** The desc tipo. */
	private String descTipo;
	
	/** The dese tipo. */
	private String deseTipo;
	
	/** The tamanyo. */
	private int tamanyo;
	
	//Campos acuses de recibo
	private String idRemesaAcuse;
	private String codRemesaAcuse;
	private String idColeccionAcuse;
	private String codColeccionAcuse;
	private String idEnvioAcuse;
	private String codEnvioAcuse;
	
	
	/**
	 * Sets the tamanyo.
	 * 
	 * @param tamanyo the new tamanyo
	 */
	public void setTamanyo (int tamanyo)
	{
		this.tamanyo=tamanyo;
	}
	
	/**
	 * Gets the tamanyo.
	 * 
	 * @return the tamanyo
	 */
	public int getTamanyo ()
	{
		return this.tamanyo;
	}
	
	/**
	 * Gets the file data.
	 * 
	 * @return the file data
	 */
	public InputStream getFileData()
	{
		return this.fileData;
	}
	
	/**
	 * Sets the file data.
	 * 
	 * @param fileData the new file data
	 */
	public void setFileData (InputStream fileData)
	{
		this.fileData=fileData;
	}
	
	/**
	 * Gets the usuario.
	 * 
	 * @return the usuario
	 */
	public String getUsuario() {
		return usuario;
	}
	
	/**
	 * Sets the usuario.
	 * 
	 * @param usuario the new usuario
	 */
	public void setUsuario(String usuario) {
		this.usuario = usuario;
	}
	
	/**
	 * Gets the nombre.
	 * 
	 * @return the nombre
	 */
	public String getNombre() {
		return nombre;
	}
	
	/**
	 * Sets the nombre.
	 * 
	 * @param nombre the new nombre
	 */
	public void setNombre(String nombre) {
		this.nombre = nombre;
	}
	
	/**
	 * Gets the tipo documento.
	 * 
	 * @return the tipo documento
	 */
	public String getTipoDocumento() {
		return tipoDocumento;
	}
	
	/**
	 * Sets the tipo documento.
	 * 
	 * @param tipoDocumento the new tipo documento
	 */
	public void setTipoDocumento(String tipoDocumento) {
		this.tipoDocumento = tipoDocumento;
	}
	
	/**
	 * Gets the fecha registro.
	 * 
	 * @return the fecha registro
	 */
	public String getFechaRegistro() {
		return fechaRegistro;
	}
	
	/**
	 * Sets the fecha registro.
	 * 
	 * @param fechaRegistro the new fecha registro
	 */
	public void setFechaRegistro(String fechaRegistro) {
		this.fechaRegistro = fechaRegistro;
	}
	
	/**
	 * Gets the numero registro.
	 * 
	 * @return the numero registro
	 */
	public String getNumeroRegistro() {
		return numeroRegistro;
	}
	
	/**
	 * Sets the numero registro.
	 * 
	 * @param numeroRegistro the new numero registro
	 */
	public void setNumeroRegistro(String numeroRegistro) {
		this.numeroRegistro = numeroRegistro;
	}
	
	/**
	 * Row to bean.
	 * 
	 * @param o the o
	 * @param otrosValores the otros valores
	 * @return the object
	 * @throws Exception the exception
	 */
	public Object rowToBean(Object o, Object otrosValores) throws Exception {
		ResultSet rs = (ResultSet)o;//NOPMD
		this.id=W83bDataBase.getStringFromRS(rs, W83bImpugnacionesBD.id_docu_041);
		this.fileDataBlob=W83bDataBase.getBlobFromRS(rs, W83bImpugnacionesBD.docu_041);
		this.nombre=W83bDataBase.getStringFromRS(rs, W83bImpugnacionesBD.nomb_docu_041);
		this.tipoDocumento=W83bDataBase.getStringFromRS(rs, W83bImpugnacionesBD.tp_doc_041);
		
		this.fechaRegistro=W83bDataBase.getStringFromRS(rs, W83bImpugnacionesBD.f_reg_041);
		
		this.descTipo=W83bDataBase.getStringFromRS(rs, W83bPreavisosBD.desc_cas_069);
		this.deseTipo=W83bDataBase.getStringFromRS(rs, W83bPreavisosBD.desc_eus_069);
		this.numeroRegistro=W83bDataBase.getStringFromRS(rs, W83bImpugnacionesBD.num_reg_041);
		this.usuario=W83bDataBase.getStringFromRS(rs, W83bImpugnacionesBD.usuario_041);
		
		this.codTramite=W83bDataBase.getStringFromRS(rs, W83bImpugnacionesBD.c_tram_041);
		this.descTramite=W83bDataBase.getStringFromRS(rs, W83bTramitesBD.nomTramite_Cast);
		this.deseTramite=W83bDataBase.getStringFromRS(rs, W83bTramitesBD.nomTramite_Eusk);
		
		this.idRemesaAcuse=W83bDataBase.getStringFromRS(rs, W83bImpugnacionesBD.id_remesa_acuse_041);
		this.codRemesaAcuse=W83bDataBase.getStringFromRS(rs, W83bImpugnacionesBD.cod_remesa_acuse_041);
		this.idColeccionAcuse=W83bDataBase.getStringFromRS(rs, W83bImpugnacionesBD.id_coleccion_acuse_041);
		this.codColeccionAcuse=W83bDataBase.getStringFromRS(rs, W83bImpugnacionesBD.cod_coleccion_acuse_041);
		this.idEnvioAcuse=W83bDataBase.getStringFromRS(rs, W83bImpugnacionesBD.id_envio_acuse_041);
		this.codEnvioAcuse=W83bDataBase.getStringFromRS(rs, W83bImpugnacionesBD.cod_envio_acuse_041);
		
		
		return this;
	}

	/**
	 * Gets the id.
	 * 
	 * @return the id
	 */
	public String getId() {
		return id;
	}

	/**
	 * Sets the id.
	 * 
	 * @param id the new id
	 */
	public void setId(String id) {
		this.id = id;
	}

	/**
	 * Gets the file data blob.
	 * 
	 * @return the file data blob
	 */
	public Blob getFileDataBlob() {
		return fileDataBlob;
	}

	/**
	 * Sets the file data blob.
	 * 
	 * @param fileDataBlob the new file data blob
	 */
	public void setFileDataBlob(Blob fileDataBlob) {
		this.fileDataBlob = fileDataBlob;
	}

	/**
	 * Gets the cod fase.
	 * 
	 * @return the cod fase
	 */
	public String getCodFase() {
		return codFase;
	}

	/**
	 * Sets the cod fase.
	 * 
	 * @param codFase the new cod fase
	 */
	public void setCodFase(String codFase) {
		this.codFase = codFase;
	}

	/**
	 * Gets the cod tramite.
	 * 
	 * @return the cod tramite
	 */
	public String getCodTramite() {
		return codTramite;
	}

	/**
	 * Sets the cod tramite.
	 * 
	 * @param codTramite the new cod tramite
	 */
	public void setCodTramite(String codTramite) {
		this.codTramite = codTramite;
	}

	/**
	 * Gets the desc tipo.
	 * 
	 * @return the desc tipo
	 */
	public String getDescTipo() {
		return descTipo;
	}

	/**
	 * Sets the desc tipo.
	 * 
	 * @param descTipo the new desc tipo
	 */
	public void setDescTipo(String descTipo) {
		this.descTipo = descTipo;
	}

	/**
	 * Gets the dese tipo.
	 * 
	 * @return the dese tipo
	 */
	public String getDeseTipo() {
		return deseTipo;
	}

	/**
	 * Sets the dese tipo.
	 * 
	 * @param deseTipo the new dese tipo
	 */
	public void setDeseTipo(String deseTipo) {
		this.deseTipo = deseTipo;
	}

	public String getDescTramite() {
		return descTramite;
	}

	public void setDescTramite(String descTramite) {
		this.descTramite = descTramite;
	}

	public String getDeseTramite() {
		return deseTramite;
	}

	public void setDeseTramite(String deseTramite) {
		this.deseTramite = deseTramite;
	}

	/**
	 * Gets the nombre.
	 * 
	 * @return the nombre
	 */
	public String getNombrePartido() {
		StringBuffer nombrePartido = new StringBuffer();
		
		if(null!=this.nombre && this.nombre.length()>20){
			nombrePartido = new StringBuffer();
			String nombreTemp = this.nombre;
			while(nombreTemp.length()>0){
				int tamanyo = nombreTemp.length();
				if(tamanyo>20){
					tamanyo=20;
				}
				nombrePartido.append(nombreTemp.substring(0, tamanyo)).append(" ");
				nombreTemp = nombreTemp.substring(tamanyo);
			}
		}else{
			nombrePartido = new StringBuffer(this.nombre);
		}
		
		return nombrePartido.toString();
	}

	public String getCodColeccionAcuse() {
		return codColeccionAcuse;
	}

	public void setCodColeccionAcuse(String codColeccionAcuse) {
		this.codColeccionAcuse = codColeccionAcuse;
	}

	public String getCodEnvioAcuse() {
		return codEnvioAcuse;
	}

	public void setCodEnvioAcuse(String codEnvioAcuse) {
		this.codEnvioAcuse = codEnvioAcuse;
	}

	public String getCodRemesaAcuse() {
		return codRemesaAcuse;
	}

	public void setCodRemesaAcuse(String codRemesaAcuse) {
		this.codRemesaAcuse = codRemesaAcuse;
	}

	public String getIdColeccionAcuse() {
		return idColeccionAcuse;
	}

	public void setIdColeccionAcuse(String idColeccionAcuse) {
		this.idColeccionAcuse = idColeccionAcuse;
	}

	public String getIdEnvioAcuse() {
		return idEnvioAcuse;
	}

	public void setIdEnvioAcuse(String idEnvioAcuse) {
		this.idEnvioAcuse = idEnvioAcuse;
	}

	public String getIdRemesaAcuse() {
		return idRemesaAcuse;
	}

	public void setIdRemesaAcuse(String idRemesaAcuse) {
		this.idRemesaAcuse = idRemesaAcuse;
	}
	
}
